#version 150
#extension GL_ARB_explicit_attrib_location : enable
layout( points ) in;
layout( triangle_strip, max_vertices = 12 ) out;

struct LightInfo
{
	vec3 position;
	vec3 color;
};
LightInfo LightOne;

uniform float halfSize;
uniform mat4 pMat;
uniform mat4 cMat;
uniform mat4 iMat;
out vec2 TexCoord;

out vec3 colOut;

bool visible(vec3 v0, vec3 v1, vec3 v2, vec3 lightPos)
{
	vec3 normal = cross(v1 - v0, v2 - v0);
	float d = dot(v0, normal);
	return (dot(lightPos, normal) - d > 0);
}

in vec3 pos[];

void main()
{
vec4 lightPos = cMat*vec4(LightOne.position, 1.0);
/*
vec4 sprite[4];
sprite[0] = vec4(-halfSize,-halfSize,0.0,1.0) + gl_in[0].gl_Position;
sprite[1] = vec4(halfSize,-halfSize,0.0,1.0) + gl_in[0].gl_Position;
sprite[2] = vec4(-halfSize,halfSize,0.0,1.0) + gl_in[0].gl_Position;
sprite[3] = vec4(halfSize,halfSize,0.0,1.0) + gl_in[0].gl_Position;
*/

vec4 testPos = vec4(0.0,0.0,0.0,0.0);

vec4 volume[4];
volume[0] = vec4(-halfSize,0.0,-halfSize,1.0) + testPos;
volume[1] = vec4(halfSize,0.0,-halfSize,1.0) + testPos;
volume[2] = vec4(-halfSize,0.0,halfSize,1.0) + testPos;
volume[3] = vec4(halfSize,0.0,halfSize,1.0) + testPos;

if(!visible(volume[0].xyz, volume[1].xyz, volume[2].xyz, lightPos.xyz))
colOut = vec3(0.1, 0.0, 0.0);
else colOut = vec3(0.0, 0.1, 0.0);

for(int i=0 ;i<4 ; i++) volume[i] = cMat * volume[i];

vec4 volumeOut[4];
for(int i=0 ; i<4 ; i++)
{
	vec4 ext = volume[i]-lightPos;
	volumeOut[i] = volume[i] + (ext * 10);
	volumeOut[i] = pMat * volumeOut[i];
	volume[i] = pMat * volume[i];
	sprite[i] = pMat * sprite[i];
}

gl_Position = sprite[0];
EmitVertex();
gl_Position = sprite[1];
EmitVertex();
gl_Position = sprite[2];
EmitVertex();
gl_Position = sprite[3];
EmitVertex();
EndPrimitive();


gl_Position = volume[2];
EmitVertex();
gl_Position = volume[3];
EmitVertex();
gl_Position = volumeOut[2];
EmitVertex();
gl_Position = volumeOut[3];
EmitVertex();
EndPrimitive();

gl_Position = volume[0];
EmitVertex();
gl_Position = volume[1];
EmitVertex();
gl_Position = volumeOut[0];
EmitVertex();
gl_Position = volumeOut[1];
EmitVertex();
EndPrimitive();
}